var History = function() {
	this.node = document.createElement("div");
	this.nodeTable = document.createElement("table");
	this.nodePreviewTr = document.createElement("tr");
	this.nodePreviewLabel = document.createElement("td");
	this.init();
};

History.prototype.init = function() {
	this.node.className = "history";
	this.node.appendChild(this.nodeTable);

	this.nodeTable.appendChild(this.nodePreviewTr);
	this.nodePreviewTr.className = "preview";
	this.nodePreviewTr.appendChild(this.nodePreviewLabel);
	this.nodePreviewLabel.appendChild(document.createTextNode(""));
	this.nodePreviewLabel.setAttribute("colspan", 2);
	this.setPreview(false);
};

History.prototype.setPreviewVisibility = function(value) {
	this.nodePreviewTr.style.display = value ? "" : "none";
};

History.prototype.setPreview = function(label) {
	this.setPreviewVisibility(label != false);
	if (!label)
		return;
		
	this.nodePreviewLabel.firstChild.nodeValue = label;
};

History.prototype.append = function(order) {
	var tr = document.createElement("tr");
	tr.order = order;
	tr.onclick = function() { this.order.resume() }
	var sum = order.getSum();
	if (sum < 0) tr.className = "repay";

	var td = document.createElement("td");
	td.appendChild(document.createTextNode(order.getTitle()));
	td.className = "label";
	tr.appendChild(td);	
	
	var td = document.createElement("td");
	td.appendChild(document.createTextNode(sum.toFixed(2)));
	td.className = "amount";
	tr.appendChild(td);	

	this.nodeTable.insertBefore(tr, this.nodePreviewTr.nextSibling);
	
	while (this.nodeTable.childNodes.length > 128) {
		this.nodeTable.removeChild(this.nodeTable.lastChild);
	}
};

History.prototype.clear = function() {
	while (this.nodePreviewTr.nextSibling) this.nodeTable.removeChild(this.nodePreviewTr.nextSibling);
};

Reciever = function(till) {
	this.till = till;
	this.node = document.createElement("button");
	this.nodeMessage = document.createElement("div");
	this.init();
};

Reciever.prototype.init = function() {
	var self = this;
	this.node.className = "sender";
	this.node.appendChild(this.nodeMessage);
	this.nodeMessage.appendChild(document.createTextNode(""));

	this.nodeMessage.className = "message";

	this.setMessageVisibility(false);
	this.node.appendChild(document.createTextNode("Restaurer"));

	this.node.onclick = function() { self.get() };
};

Reciever.prototype.setMessageVisibility = function(value) {
	this.nodeMessage.style.display = value ? "" : "none";
};

Reciever.prototype.setMessage = function(msg) {
	this.nodeMessage.firstChild.nodeValue = msg;
};

Reciever.prototype.get = function() {
	var self = this;
	var ajax = new Ajax();

	this.setMessage("En cours…");
	this.setMessageVisibility(true);
	
	var url = "load.php?ref=" + this.till.ref;
	//url = "data/data_pelmeni_20170514_1720.json";
	ajax.query(url, "get", null, function(result) {
		self.setMessage(result ? "Ok" : "Erreur");
		if (result) self.till.restore(result);
		setTimeout(function() {
			self.setMessageVisibility(false);
		}, 1500);
	} );
};

var Product = function(title, shortTitle, ref, price, color) {
	this.till = null;
	this.color = color;
	this.price = price;
	this.title = title;
	this.shortTitle = shortTitle;
	this.ref = ref;
	this.node = document.createElement("fieldset");
	this.nodePlus = document.createElement("button");
	this.nodeMinus = document.createElement("button");
	this.nodeQuantity = document.createElement("select");
	this.init();
};

Product.maxValue = 99;

Product.prototype.setTill = function(till) {
	this.till = till;
};

Product.prototype.setMinusVisibility = function(value) {
	this.nodeMinus.style.display = value ? "" : "none";
};

Product.prototype.init = function() {
	var self = this;
	
	this.node.style.backgroundColor = this.color;
	var legend = document.createElement("legend");
	legend.appendChild(document.createTextNode(this.title));
	this.node.appendChild(legend);

	this.nodeMinus.appendChild(document.createTextNode("-"));
	this.nodeMinus.className = "minus";
	this.nodeMinus.onclick = function(e) { self.inc(-1); e.stopPropagation(); };
	this.node.appendChild(this.nodeMinus);

	this.nodeQuantity.className = "quantity";
	for (var i = 0; i <= Product.maxValue; i++) {
		var option = document.createElement("option");
		option.appendChild(document.createTextNode(i));
		option.value = i;
		this.nodeQuantity.appendChild(option);
	}
	this.nodeQuantity.onclick = function(e) { e.stopPropagation(); };
	this.nodeQuantity.onchange = function() { self.changed() };
	this.node.appendChild(this.nodeQuantity);

	this.nodePlus.appendChild(document.createTextNode("+"));
	this.nodePlus.className = "plus";
	this.node.onclick = this.nodePlus.onclick = function(e) { self.inc(1); e.stopPropagation(); };
	this.node.appendChild(this.nodePlus);

	this.set(0);
};

Product.prototype.changed = function() {
	if (this.till) this.till.updateOrder(); 
	this.node.className = "product " + (this.get() == 0 ? "empty" : "");
};

Product.prototype.getTitle = function() {
	return this.title;
};

Product.prototype.getPrice = function() {
	return this.price;
};

Product.prototype.getShortTitle = function() {
	return this.shortTitle;
};

Product.prototype.getRef = function() {
	return this.ref;
};

Product.prototype.set = function(value) {
	value = value > 0 ? value : 0;
	value = value <= Product.maxValue ? value : Product.maxValue;
	
	this.nodeQuantity.value = value;
	this.changed();
};

Product.prototype.get = function() {
	return parseInt(this.nodeQuantity.value);
};

Product.prototype.inc = function(n) {
	this.set(this.get() + n);
};

Product.prototype.sum = function() {
	return this.get() * this.price;
};


var Till = function(ref) {
	this.ref = ref;
	this.nodeSum = document.createElement("div");
	this.nodeSubmit = document.createElement("button");
	this.nodeCancel = document.createElement("button");
	this.nodeClear = document.createElement("button");
	this.sender = new Sender(this);
	this.reciever = new Reciever(this);
	this.history = new History();
	this.stats = new Stats(ref);
	this.products = [];
	this.init();
};

Till.prototype.addProduct = function(product) {
	this.products.push(product);
	product.setTill(this);
	var container = document.getElementById("p:" + product.getRef());
	if (!container) container = document.getElementById("products");
	container.appendChild(product.node);
};

Till.prototype.init = function() {
	var self = this;

	this.nodeSum.appendChild(document.createTextNode("-"));
	this.nodeSum.className = "sum";
	this.nodeSum.onclick = function() { self.clearOrder() };
	var container = document.getElementById("sum").appendChild(this.nodeSum);

	this.nodeSubmit.appendChild(document.createTextNode("Encaisser"));
	this.nodeSubmit.onclick = function() { self.pay(1) };
	this.nodeSubmit.className = "pay";
	document.getElementById("pay").appendChild(this.nodeSubmit);

	this.nodeCancel.appendChild(document.createTextNode("Rembourser"));
	this.nodeCancel.className = "repay";
	this.nodeCancel.onclick = function() { self.pay(-1) };
	document.getElementById("repay").appendChild(this.nodeCancel);

	document.getElementById("history").appendChild(this.history.node);
	document.getElementById("stats").appendChild(this.stats.node);


	document.getElementById("tools").appendChild(this.sender.node);

	this.nodeClear.className = "clear";
	this.setClearVisibility(false);
	this.nodeClear.onclick = function() { self.clear() };
	this.nodeClear.appendChild(document.createTextNode("R.A.Z"));
	document.getElementById("tools").appendChild(this.nodeClear);

	document.getElementById("tools").appendChild(this.reciever.node);
	this.update();
};

Till.prototype.setMinusVisibility = function(value) {
	for (var i = 0; i < this.products.length; i++) {
		var product = this.products[i];
		product.setMinusVisibility(value);
	}
};

Till.prototype.update = function() {
	this.updateOrder();
	this.stats.show(this.products);
};

Till.prototype.pay = function(factor) {
	var order = this.getOrder(factor);

	if (order.isEmpty()) return;
	order.addToStats(this.stats);
	
	this.history.append(order);
	this.clearOrder();
	this.stats.show(this.products);
};

Till.prototype.getOrder = function(factor) {
	if (!factor) factor = 1;
	var order = new Order(this, factor);
	for (var i = 0; i < this.products.length; i++) {
		var product = this.products[i];
		if (product.get() != 0)	order.set(product, product.get());
	}
	return order;
};

Till.prototype.updateOrder = function() {
	//easer egg
	var easterEggActivate = this.products.length >= 2 && this.products[0].get() == 19 && this.products[1].get() == 17;
	//easterEggActivate = true;
	this.setClearVisibility(easterEggActivate);
	this.setRestoreVisibility(easterEggActivate);

	var order = this.getOrder();
	this.setSum(order.getSum());
	this.history.setPreview(order.isEmpty() ? false : order.getTitle());
};

Till.prototype.clearOrder = function() {
	for (var i = 0; i < this.products.length; i++) {
		var product = this.products[i];
		product.set(0);
	}
	this.updateOrder();
};

Till.prototype.setSum = function(value) {
	this.nodeSum.firstChild.nodeValue = value.toFixed(2);
};

Till.prototype.serialize = function() {
	var keys = this.localStorageKeys();
	var data = {};
	for (var i = 0; i < keys.length; i++) {
		var key = keys[i];
		data[key] = localStorage.getItem(key);
	}
	return data;
};

Till.prototype.unserialize = function(data) {
	for (key in data) {
		localStorage.setItem(key, data[key]);
	}
};

Till.prototype.setClearVisibility = function(value) {
	this.nodeClear.style.display = value ? "" : "none";
};

Till.prototype.setRestoreVisibility = function(value) {
	this.reciever.node.style.display = value ? "" : "none";
};

Till.prototype.localStorageKeys = function() {
	var result = [];
	for (var i = 0; i < localStorage.length; i++) {
		var key = localStorage.key(i);
		var prefix = this.ref + "::";
		if (key.substr(0, prefix.length) == prefix)
			result.push(key);
	}
	return result;
};

Till.prototype.localStorageClear = function() {
	var toDelete = this.localStorageKeys();
	for (var i = 0; i < toDelete.length; i++) {
		var key = toDelete[i];
		localStorage.removeItem(key);
	}
};

Till.prototype.clear = function() {
	this.localStorageClear();
	this.stats.show(this.products);
	this.history.clear();
	this.clearOrder();
};

Till.prototype.restore = function(data) {
	this.unserialize(data);
	this.stats.show(this.products);
	this.history.clear();
	this.clearOrder();
};
var Order = function(till, factor) {
	this.till = till;
	this.factor = factor;
	this.details = {};
};

Order.prototype.isEmpty = function() {
	for (ref in this.details) {
		return false;
	}
	return true;
};

Order.prototype.set = function(product, quantity) {
	this.details[product.getRef()] = quantity;
};

Order.prototype.getTitle = function() {
	var label = "";
	for (var i = 0; i < this.till.products.length; i++) {
		var product = this.till.products[i];
		var ref = product.getRef();
		if (ref in this.details) {
			var quantity = this.details[ref]; 
			if (label) label += " + ";
			label += quantity +  "×" + product.getTitle();
		}
	}

	return label;
};

Order.prototype.addToStats = function(stats) {
	for (var i = 0; i < this.till.products.length; i++) {
		var product = this.till.products[i];
		var ref = product.getRef();
		if (ref in this.details) {
			var quantity = this.details[ref]; 
			stats.append(ref, quantity * this.factor);
		}
	}
};

Order.prototype.resume = function() {
	for (var i = 0; i < this.till.products.length; i++) {
		var product = this.till.products[i];
		var ref = product.getRef();
		if (ref in this.details) {
			var quantity = this.details[ref]; 
			product.set(quantity);
		}
		else {
			product.set(0);
		}
	}
	this.till.updateOrder();
};

Order.prototype.getSum = function() {
	var sum = 0;
	for (var i = 0; i < this.till.products.length; i++) {
		var product = this.till.products[i];
		var ref = product.getRef();
		if (ref in this.details) {
			var quantity = this.details[ref]; 
			sum += quantity * product.getPrice();
		}
	}
	return sum * this.factor;
};

var Ajax = function() {
	this.status = {
		400: "Bad Request",
		401: "Unauthorized",
		404: "Not Found",
		500: "Internal Server Error",
		501: "Not Implemented"
	};
};

Ajax.prototype.query = function(uri, method, params, fct) {
	var this_ = this;
	var xhttp = new XMLHttpRequest();
	xhttp.onreadystatechange = function() {
		if (xhttp.readyState == 4) {
			status = xhttp.status;
			if (status != 200) {
				this_.error("HTTP Error", status, status in this_.status ? this_.status[status] : "");
			}
			fct(status == 200 ? JSON.parse(xhttp.responseText) : null);
		}
	}
	xhttp.open(method, uri, true);
	xhttp.send(params);
};

Ajax.prototype.error = function(type, code, description) {
	console.log(type + ": " + code + " (" + description+")");
};

var Stats = function(ref) {
	this.ref = ref;
	this.node = document.createElement("div");
	this.nodeTable = document.createElement("table");
	this.nodeDays = document.createElement("div");
	this.init();
};

Stats.prototype.init = function() {
	this.node.className = "stats";
	this.node.appendChild(this.nodeTable);
	this.node.appendChild(this.nodeDays);
};

Stats.prototype.get = function(key) {
	var str = localStorage.getItem(key);
	return !str ? 0 : parseInt(str);
};

Stats.prototype.inc = function(key, n) {
	value = this.get(key);
	value += n;
	localStorage.setItem(key, value);
};

Stats.prototype.getDateKeys = function() {
	var str = localStorage.getItem(this.ref + "::" + "dates");
	keys = !str ? [] : JSON.parse(str);
	if (!Array.isArray(keys)) keys = [];
	keys.sort(function(a, b) {
		return a > b;
	});
	return keys;
};

Stats.prototype.setDateKeys = function(dates) {
	var str = JSON.stringify(dates);
	localStorage.setItem(this.ref + "::" + "dates", str);
};

Stats.prototype.addDateKey = function(key) {
	var keys = this.getDateKeys();
	var arr = {};
	for (var i = 0; i < keys.length; i++) {
		arr[keys[i]] = true;
	}

	arr[key] = true;

	var keys = [];
	for (key in arr) {
		keys.push(key);
	}

	this.setDateKeys(keys);
};

Stats.prototype.getDateKey = function(date) {
	return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
};

Stats.prototype.getDateKeyTitle = function(key, long) {
	var arr = key.split("-");
	var d = parseInt(arr[2]);
	var m = parseInt(arr[1]);
	var y = parseInt(arr[0]);
	 
	return d + "/" + (m <= 9 ? "0" : "") + m + (long ? "/" + y : "");
};

Stats.prototype.append = function(ref, num) {
	this.inc(this.ref + "::" + ref + "::sum", num);

	var date = new Date();
	var dateKey = this.getDateKey(date);
	this.addDateKey(dateKey); 

	this.inc(this.ref + "::" + ref + "::h::" + dateKey + "::" + date.getHours(), num);
	this.inc(this.ref + "::" + ref + "::d::" + dateKey, num);
//	console.log(JSON.stringify(this.getDateKeys()));
};

Stats.prototype.showDate = function(products, key) {
	var table = document.createElement("table");

	var tr = document.createElement("tr");
	table.appendChild(tr);
	table.className = "statsDate";
	
	var th = document.createElement("th");
	th.appendChild(document.createTextNode(this.getDateKeyTitle(key)));
	tr.appendChild(th);

	for (var i = 0; i < products.length; i++) {
		var product = products[i];

		var th = document.createElement("th");
		th.appendChild(document.createTextNode(product.getShortTitle()));
		tr.appendChild(th);
	}

	for (var h = 0; h < 24; h++) {
		var tr = document.createElement("tr");
		
		var th = document.createElement("th");
		th.appendChild(document.createTextNode(h + "h"));
		tr.appendChild(th);

		var content = false;
		for (var i = 0; i < products.length; i++) {
			var product = products[i];
			var td = document.createElement("td");
			var value = this.get(this.ref + "::" + product.getRef() + "::h::" + key + "::" + h);
			if (value != 0) content = true;
			td.appendChild(document.createTextNode(value));
			tr.appendChild(td);
		}
		if (content) table.appendChild(tr);
	}
	return table;
};

Stats.prototype.show = function(products) {
	while (this.nodeTable.firstChild) this.nodeTable.removeChild(this.nodeTable.firstChild);

	var date = new Date();

	var tr = document.createElement("tr");
	this.nodeTable.appendChild(tr);
	
	var th = document.createElement("th");
	tr.appendChild(th);

	var dateKeys = this.getDateKeys().reverse();
	for (var j = 0; j < dateKeys.length; j++) {
		var dateKey = dateKeys[j];
		var th = document.createElement("th");
		tr.appendChild(th);
		th.appendChild(document.createTextNode(this.getDateKeyTitle(dateKey, false)));
	};
			
	var th = document.createElement("th");
	tr.appendChild(th);
	th.appendChild(document.createTextNode("total"));

	for (var i = 0; i < products.length; i++) {
		var product = products[i];
		var ref = product.getRef();
		
		var tr = document.createElement("tr");


		var th = document.createElement("th");
		tr.appendChild(th);
		th.appendChild(document.createTextNode(product.getTitle()));

		for (var j = 0; j < dateKeys.length; j++) {
			var dateKey = dateKeys[j];
			var td = document.createElement("td");
			tr.appendChild(td);
			td.appendChild(document.createTextNode(this.get(this.ref + "::" + ref + "::d::" + dateKey)));
		}
		
		var td = document.createElement("td");
		tr.appendChild(td);
		td.appendChild(document.createTextNode(this.get(this.ref + "::" + ref + "::sum")));
		
		this.nodeTable.appendChild(tr);
	}	

	while (this.nodeDays.firstChild) this.nodeDays.removeChild(this.nodeDays.firstChild);
	for (var i = 0; i < dateKeys.length; i++) {
		var dateKey = dateKeys[i];
		this.nodeDays.appendChild(this.showDate(products, dateKey));
	}

};

Sender = function(till) {
	this.till = till;
	this.node = document.createElement("button");
	this.nodeMessage = document.createElement("div");
	this.init();
};

Sender.prototype.init = function() {
	var self = this;
	this.node.className = "sender";
	this.node.appendChild(this.nodeMessage);
	this.nodeMessage.appendChild(document.createTextNode(""));

	this.nodeMessage.className = "message";

	this.setMessageVisibility(false);
	this.node.appendChild(document.createTextNode("Enregistrer"));

	this.node.onclick = function() { self.post() };
};

Sender.prototype.setMessageVisibility = function(value) {
	this.nodeMessage.style.display = value ? "" : "none";
};

Sender.prototype.setMessage = function(msg) {
	this.nodeMessage.firstChild.nodeValue = msg;
};

Sender.prototype.post = function() {
	var self = this;
	var ajax = new Ajax();

	var data = this.till.serialize();
	var json = JSON.stringify(data);

	this.setMessage("En cours…");
	this.setMessageVisibility(true);
	
	ajax.query("save.php?ref=" + this.till.ref, "post", json, function(success) {
		self.setMessage(success ? "Ok" : "Erreur");
		setTimeout(function() {
			self.setMessageVisibility(false);
		}, 1500);
	} );
};

