var Ajax = function() {
	this.status = {
		400: "Bad Request",
		401: "Unauthorized",
		404: "Not Found",
		500: "Internal Server Error",
		501: "Not Implemented"
	};
};

Ajax.prototype.query = function(uri, method, params, fct) {
	var this_ = this;
	var xhttp = new XMLHttpRequest();
	xhttp.onreadystatechange = function() {
		if (xhttp.readyState == 4) {
			status = xhttp.status;
			if (status != 200) {
				this_.error("HTTP Error", status, status in this_.status ? this_.status[status] : "");
			}
			fct(status == 200 ? JSON.parse(xhttp.responseText) : null);
		}
	}
	xhttp.open(method, uri, true);
	xhttp.send(params);
};

Ajax.prototype.error = function(type, code, description) {
	console.log(type + ": " + code + " (" + description+")");
};

