var History = function() {
	this.node = document.createElement("div");
	this.nodeTable = document.createElement("table");
	this.nodePreviewTr = document.createElement("tr");
	this.nodePreviewLabel = document.createElement("td");
	this.init();
};

History.prototype.init = function() {
	this.node.className = "history";
	this.node.appendChild(this.nodeTable);

	this.nodeTable.appendChild(this.nodePreviewTr);
	this.nodePreviewTr.className = "preview";
	this.nodePreviewTr.appendChild(this.nodePreviewLabel);
	this.nodePreviewLabel.appendChild(document.createTextNode(""));
	this.nodePreviewLabel.setAttribute("colspan", 2);
	this.setPreview(false);
};

History.prototype.setPreviewVisibility = function(value) {
	this.nodePreviewTr.style.display = value ? "" : "none";
};

History.prototype.setPreview = function(label) {
	this.setPreviewVisibility(label != false);
	if (!label)
		return;
		
	this.nodePreviewLabel.firstChild.nodeValue = label;
};

History.prototype.append = function(order) {
	var tr = document.createElement("tr");
	tr.order = order;
	tr.onclick = function() { this.order.resume() }
	var sum = order.getSum();
	if (sum < 0) tr.className = "repay";

	var td = document.createElement("td");
	td.appendChild(document.createTextNode(order.getTitle()));
	td.className = "label";
	tr.appendChild(td);	
	
	var td = document.createElement("td");
	td.appendChild(document.createTextNode(sum.toFixed(2)));
	td.className = "amount";
	tr.appendChild(td);	

	this.nodeTable.insertBefore(tr, this.nodePreviewTr.nextSibling);
	
	while (this.nodeTable.childNodes.length > 128) {
		this.nodeTable.removeChild(this.nodeTable.lastChild);
	}
};

History.prototype.clear = function() {
	while (this.nodePreviewTr.nextSibling) this.nodeTable.removeChild(this.nodePreviewTr.nextSibling);
};

