var Order = function(till, factor) {
	this.till = till;
	this.factor = factor;
	this.details = {};
};

Order.prototype.isEmpty = function() {
	for (ref in this.details) {
		return false;
	}
	return true;
};

Order.prototype.set = function(product, quantity) {
	this.details[product.getRef()] = quantity;
};

Order.prototype.getTitle = function() {
	var label = "";
	for (var i = 0; i < this.till.products.length; i++) {
		var product = this.till.products[i];
		var ref = product.getRef();
		if (ref in this.details) {
			var quantity = this.details[ref]; 
			if (label) label += " + ";
			label += quantity +  "×" + product.getTitle();
		}
	}

	return label;
};

Order.prototype.addToStats = function(stats) {
	for (var i = 0; i < this.till.products.length; i++) {
		var product = this.till.products[i];
		var ref = product.getRef();
		if (ref in this.details) {
			var quantity = this.details[ref]; 
			stats.append(ref, quantity * this.factor);
		}
	}
};

Order.prototype.resume = function() {
	for (var i = 0; i < this.till.products.length; i++) {
		var product = this.till.products[i];
		var ref = product.getRef();
		if (ref in this.details) {
			var quantity = this.details[ref]; 
			product.set(quantity);
		}
		else {
			product.set(0);
		}
	}
	this.till.updateOrder();
};

Order.prototype.getSum = function() {
	var sum = 0;
	for (var i = 0; i < this.till.products.length; i++) {
		var product = this.till.products[i];
		var ref = product.getRef();
		if (ref in this.details) {
			var quantity = this.details[ref]; 
			sum += quantity * product.getPrice();
		}
	}
	return sum * this.factor;
};

