var Product = function(title, shortTitle, ref, price, color) {
	this.till = null;
	this.color = color;
	this.price = price;
	this.title = title;
	this.shortTitle = shortTitle;
	this.ref = ref;
	this.node = document.createElement("fieldset");
	this.nodePlus = document.createElement("button");
	this.nodeMinus = document.createElement("button");
	this.nodeQuantity = document.createElement("select");
	this.init();
};

Product.maxValue = 99;

Product.prototype.setTill = function(till) {
	this.till = till;
};

Product.prototype.init = function() {
	var self = this;
	
	this.node.style.backgroundColor = this.color;
	var legend = document.createElement("legend");
	legend.appendChild(document.createTextNode(this.title));
	this.node.appendChild(legend);

	this.nodeMinus.appendChild(document.createTextNode("-"));
	this.nodeMinus.className = "minus";
	this.nodeMinus.onclick = function(e) { self.inc(-1); e.stopPropagation(); };
	this.node.appendChild(this.nodeMinus);

	this.nodeQuantity.className = "quantity";
	for (var i = 0; i <= Product.maxValue; i++) {
		var option = document.createElement("option");
		option.appendChild(document.createTextNode(i));
		option.value = i;
		this.nodeQuantity.appendChild(option);
	}
	this.nodeQuantity.onclick = function(e) { e.stopPropagation(); };
	this.nodeQuantity.onchange = function() { self.changed() };
	this.node.appendChild(this.nodeQuantity);

	this.nodePlus.appendChild(document.createTextNode("+"));
	this.nodePlus.className = "plus";
	this.node.onclick = this.nodePlus.onclick = function(e) { self.inc(1); e.stopPropagation(); };
	this.node.appendChild(this.nodePlus);

	this.set(0);
};

Product.prototype.changed = function() {
	if (this.till) this.till.updateOrder(); 
	this.node.className = "product " + (this.get() == 0 ? "empty" : "");
};

Product.prototype.getTitle = function() {
	return this.title;
};

Product.prototype.getPrice = function() {
	return this.price;
};

Product.prototype.getShortTitle = function() {
	return this.shortTitle;
};

Product.prototype.getRef = function() {
	return this.ref;
};

Product.prototype.set = function(value) {
	value = value > 0 ? value : 0;
	value = value <= Product.maxValue ? value : Product.maxValue;
	
	this.nodeQuantity.value = value;
	this.changed();
};

Product.prototype.get = function() {
	return parseInt(this.nodeQuantity.value);
};

Product.prototype.inc = function(n) {
	this.set(this.get() + n);
};

Product.prototype.sum = function() {
	return this.get() * this.price;
};


