Sender = function(till) {
	this.till = till;
	this.node = document.createElement("button");
	this.nodeMessage = document.createElement("div");
	this.init();
};

Sender.prototype.init = function() {
	var self = this;
	this.node.className = "sender";
	this.node.appendChild(this.nodeMessage);
	this.nodeMessage.appendChild(document.createTextNode(""));

	this.nodeMessage.className = "message";

	this.setMessageVisibility(false);
	this.node.appendChild(document.createTextNode("Enregistrer"));

	this.node.onclick = function() { self.post() };
};

Sender.prototype.setMessageVisibility = function(value) {
	this.nodeMessage.style.display = value ? "" : "none";
};

Sender.prototype.setMessage = function(msg) {
	this.nodeMessage.firstChild.nodeValue = msg;
};

Sender.prototype.post = function() {
	var self = this;
	var ajax = new Ajax();

	var data = this.till.serialize();
	var json = JSON.stringify(data);

	this.setMessage("En cours…");
	this.setMessageVisibility(true);
	
	ajax.query("save.php?ref=" + this.till.ref, "post", json, function(success) {
		self.setMessage(success ? "Ok" : "Erreur");
		setTimeout(function() {
			self.setMessageVisibility(false);
		}, 1500);
	} );
};

