var Stats = function(ref) {
	this.ref = ref;
	this.node = document.createElement("div");
	this.nodeTable = document.createElement("table");
	this.nodeDays = document.createElement("div");
	this.init();
};

Stats.prototype.init = function() {
	this.node.className = "stats";
	this.node.appendChild(this.nodeTable);
	this.node.appendChild(this.nodeDays);
};

Stats.prototype.get = function(key) {
	var str = localStorage.getItem(key);
	return !str ? 0 : parseInt(str);
};

Stats.prototype.inc = function(key, n) {
	value = this.get(key);
	value += n;
	localStorage.setItem(key, value);
};

Stats.prototype.getDateKeys = function() {
	var str = localStorage.getItem(this.ref + "::" + "dates");
	keys = !str ? [] : JSON.parse(str);
	if (!Array.isArray(keys)) keys = [];
	keys.sort(function(a, b) {
		return a > b;
	});
	return keys;
};

Stats.prototype.setDateKeys = function(dates) {
	var str = JSON.stringify(dates);
	localStorage.setItem(this.ref + "::" + "dates", str);
};

Stats.prototype.addDateKey = function(key) {
	var keys = this.getDateKeys();
	var arr = {};
	for (var i = 0; i < keys.length; i++) {
		arr[keys[i]] = true;
	}

	arr[key] = true;

	var keys = [];
	for (key in arr) {
		keys.push(key);
	}

	this.setDateKeys(keys);
};

Stats.prototype.getDateKey = function(date) {
	return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
};

Stats.prototype.getDateKeyTitle = function(key, long) {
	var arr = key.split("-");
	var d = parseInt(arr[2]);
	var m = parseInt(arr[1]);
	var y = parseInt(arr[0]);
	 
	return d + "/" + (m <= 9 ? "0" : "") + m + (long ? "/" + y : "");
};

Stats.prototype.append = function(ref, num) {
	this.inc(this.ref + "::" + ref + "::sum", num);

	var date = new Date();
	var dateKey = this.getDateKey(date);
	this.addDateKey(dateKey); 

	this.inc(this.ref + "::" + ref + "::h::" + dateKey + "::" + date.getHours(), num);
	this.inc(this.ref + "::" + ref + "::d::" + dateKey, num);
//	console.log(JSON.stringify(this.getDateKeys()));
};

Stats.prototype.showDate = function(products, key) {
	var table = document.createElement("table");

	var tr = document.createElement("tr");
	table.appendChild(tr);
	table.className = "statsDate";
	
	var th = document.createElement("th");
	th.appendChild(document.createTextNode(this.getDateKeyTitle(key)));
	tr.appendChild(th);

	for (var i = 0; i < products.length; i++) {
		var product = products[i];

		var th = document.createElement("th");
		th.appendChild(document.createTextNode(product.getShortTitle()));
		tr.appendChild(th);
	}

	for (var h = 0; h < 24; h++) {
		var tr = document.createElement("tr");
		
		var th = document.createElement("th");
		th.appendChild(document.createTextNode(h + "h"));
		tr.appendChild(th);

		var content = false;
		for (var i = 0; i < products.length; i++) {
			var product = products[i];
			var td = document.createElement("td");
			var value = this.get(this.ref + "::" + product.getRef() + "::h::" + key + "::" + h);
			if (value != 0) content = true;
			td.appendChild(document.createTextNode(value));
			tr.appendChild(td);
		}
		if (content) table.appendChild(tr);
	}
	return table;
};

Stats.prototype.show = function(products) {
	while (this.nodeTable.firstChild) this.nodeTable.removeChild(this.nodeTable.firstChild);

	var date = new Date();

	var tr = document.createElement("tr");
	this.nodeTable.appendChild(tr);
	
	var th = document.createElement("th");
	tr.appendChild(th);

	var dateKeys = this.getDateKeys().reverse();
	for (var j = 0; j < dateKeys.length; j++) {
		var dateKey = dateKeys[j];
		var th = document.createElement("th");
		tr.appendChild(th);
		th.appendChild(document.createTextNode(this.getDateKeyTitle(dateKey, false)));
	};
			
	var th = document.createElement("th");
	tr.appendChild(th);
	th.appendChild(document.createTextNode("total"));

	for (var i = 0; i < products.length; i++) {
		var product = products[i];
		var ref = product.getRef();
		
		var tr = document.createElement("tr");


		var th = document.createElement("th");
		tr.appendChild(th);
		th.appendChild(document.createTextNode(product.getTitle()));

		for (var j = 0; j < dateKeys.length; j++) {
			var dateKey = dateKeys[j];
			var td = document.createElement("td");
			tr.appendChild(td);
			td.appendChild(document.createTextNode(this.get(this.ref + "::" + ref + "::d::" + dateKey)));
		}
		
		var td = document.createElement("td");
		tr.appendChild(td);
		td.appendChild(document.createTextNode(this.get(this.ref + "::" + ref + "::sum")));
		
		this.nodeTable.appendChild(tr);
	}	

	while (this.nodeDays.firstChild) this.nodeDays.removeChild(this.nodeDays.firstChild);
	for (var i = 0; i < dateKeys.length; i++) {
		var dateKey = dateKeys[i];
		this.nodeDays.appendChild(this.showDate(products, dateKey));
	}

};

