var Till = function(ref) {
	this.ref = ref;
	this.nodeSum = document.createElement("div");
	this.nodeSubmit = document.createElement("button");
	this.nodeCancel = document.createElement("button");
	this.nodeClear = document.createElement("button");
	this.sender = new Sender(this);
	this.reciever = new Reciever(this);
	this.history = new History();
	this.stats = new Stats(ref);
	this.products = [];
	this.init();
};

Till.prototype.addProduct = function(product) {
	this.products.push(product);
	product.setTill(this);
	var container = document.getElementById("p:" + product.getRef());
	if (!container) container = document.getElementById("products");
	container.appendChild(product.node);
};

Till.prototype.init = function() {
	var self = this;

	this.nodeSum.appendChild(document.createTextNode("-"));
	this.nodeSum.className = "sum";
	this.nodeSum.onclick = function() { self.clearOrder() };
	var container = document.getElementById("sum").appendChild(this.nodeSum);

	this.nodeSubmit.appendChild(document.createTextNode("Encaisser"));
	this.nodeSubmit.onclick = function() { self.pay(1) };
	this.nodeSubmit.className = "pay";
	document.getElementById("pay").appendChild(this.nodeSubmit);

	this.nodeCancel.appendChild(document.createTextNode("Rembourser"));
	this.nodeCancel.className = "repay";
	this.nodeCancel.onclick = function() { self.pay(-1) };
	document.getElementById("repay").appendChild(this.nodeCancel);

	document.getElementById("history").appendChild(this.history.node);
	document.getElementById("stats").appendChild(this.stats.node);


	document.getElementById("tools").appendChild(this.sender.node);

	this.nodeClear.className = "clear";
	this.setClearVisibility(false);
	this.nodeClear.onclick = function() { self.clear() };
	this.nodeClear.appendChild(document.createTextNode("R.A.Z"));
	document.getElementById("tools").appendChild(this.nodeClear);

	document.getElementById("tools").appendChild(this.reciever.node);
	this.update();
};

Till.prototype.update = function() {
	this.updateOrder();
	this.stats.show(this.products);
};

Till.prototype.pay = function(factor) {
	var order = this.getOrder(factor);

	if (order.isEmpty()) return;
	order.addToStats(this.stats);
	
	this.history.append(order);
	this.clearOrder();
	this.stats.show(this.products);
};

Till.prototype.getOrder = function(factor) {
	if (!factor) factor = 1;
	var order = new Order(this, factor);
	for (var i = 0; i < this.products.length; i++) {
		var product = this.products[i];
		if (product.get() != 0)	order.set(product, product.get());
	}
	return order;
};

Till.prototype.updateOrder = function() {
	//easer egg
	var easterEggActivate = this.products.length >= 2 && this.products[0].get() == 19 && this.products[1].get() == 17;
	//easterEggActivate = true;
	this.setClearVisibility(easterEggActivate);
	this.setRestoreVisibility(easterEggActivate);

	var order = this.getOrder();
	this.setSum(order.getSum());
	this.history.setPreview(order.isEmpty() ? false : order.getTitle());
};

Till.prototype.clearOrder = function() {
	for (var i = 0; i < this.products.length; i++) {
		var product = this.products[i];
		product.set(0);
	}
	this.updateOrder();
};

Till.prototype.setSum = function(value) {
	this.nodeSum.firstChild.nodeValue = value.toFixed(2);
};

Till.prototype.serialize = function() {
	var keys = this.localStorageKeys();
	var data = {};
	for (var i = 0; i < keys.length; i++) {
		var key = keys[i];
		data[key] = localStorage.getItem(key);
	}
	return data;
};

Till.prototype.unserialize = function(data) {
	for (key in data) {
		localStorage.setItem(key, data[key]);
	}
};

Till.prototype.setClearVisibility = function(value) {
	this.nodeClear.style.display = value ? "" : "none";
};

Till.prototype.setRestoreVisibility = function(value) {
	this.reciever.node.style.display = value ? "" : "none";
};

Till.prototype.localStorageKeys = function() {
	var result = [];
	for (var i = 0; i < localStorage.length; i++) {
		var key = localStorage.key(i);
		var prefix = this.ref + "::";
		if (key.substr(0, prefix.length) == prefix)
			result.push(key);
	}
	return result;
};

Till.prototype.localStorageClear = function() {
	var toDelete = this.localStorageKeys();
	for (var i = 0; i < toDelete.length; i++) {
		var key = toDelete[i];
		localStorage.removeItem(key);
	}
};

Till.prototype.clear = function() {
	this.localStorageClear();
	this.stats.show(this.products);
	this.history.clear();
	this.clearOrder();
};

Till.prototype.restore = function(data) {
	this.unserialize(data);
	this.stats.show(this.products);
	this.history.clear();
	this.clearOrder();
};
