<?php

function getPosts() {
	$result = array();
	$path = "data/";
	$dir = opendir($path);
	while (($filename = readdir($dir)) !== false) {
		if (preg_match("/^data_([a-z\-]*)_([0-9]{8})_([0-9]{4})\.json$/", $filename, $vars)) {
			$Y = (int) substr($vars[2], 0, 4);
			$m = (int) substr($vars[2], 4, 2);
			$d = (int) substr($vars[2], 6, 4);
			$H = (int) substr($vars[3], 0, 2);
			$i = (int) substr($vars[3], 2, 2);
			$time = mktime($H, $i, 0, $m, $d, $Y);
			
			$result[] = array(
				"filename" => $path.$filename,
				"ref" => $vars[1],
				"time" => $time
			);
		}
	}
	return $result;
}

function getLastPost($ref) {
	$posts = getPosts();
	//print_r($posts);
	$result = false;
	foreach($posts as $post) {
		if ($post["ref"] == $ref && (!$result || $result["time"] < $post["time"])) {
			$result = $post;
		} 
	}
	return $result;
}

$result = false;
if (isset($_GET["ref"])) {
	$post = getLastPost($_GET["ref"]);
	if ($post) {
		$json = file_get_contents($post["filename"]);
		$result = json_decode($json);
	}
}

echo json_encode($result);




